import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const id = getRouterParam(event, 'id')
  const body = await readBody(event)

  const res: any = await event.context.fetch(`models/m_inout/${id}`, 'PUT', token, {
    'doc-action': body.documentAction
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''

    // If completing a purchase receipt, check if we need to close JTL inbound order
    if(body.documentAction === 'CO') {
      try {
        // Fetch full material receipt details with order and order source
        const receipt: any = await fetchHelper(event, 'models/m_inout/'+id+'?$expand=c_order_id', 'GET', token, null)

        // Check conditions: purchase receipt with order that has order source and jtl_order_id
        if(receipt?.IsSOTrx === false && receipt?.C_Order_ID?.C_OrderSource_ID?.id && receipt?.C_Order_ID?.jtl_order_id) {
          // Fetch order source details
          const orderSource: any = await fetchHelper(event, 'models/c_ordersource/'+receipt.C_Order_ID.C_OrderSource_ID.id, 'GET', token, null)

          // Verify it's JTL-FFN and has marketplace_url
          if((orderSource?.Marketplace?.identifier === 'jtl-ffn' || orderSource?.marketplace === '7' || orderSource?.Marketplace?.id === '7') && orderSource?.marketplace_url) {
            const jtlOrderId = receipt.C_Order_ID.jtl_order_id

            const logData = {
              jtl_order_id: jtlOrderId,
              material_receipt_id: id,
              order_id: receipt.C_Order_ID.id,
              action: 'close_inbound'
            }
            console.log('[JTL Close Inbound] Attempting to close JTL inbound order:', logData)
            data['jtl_close_inbound_log'] = { trigger: logData }

            // Build JTL API headers
            const headers: any = {
              'content-type': 'application/json',
              'accept': 'application/json'
            }
            if(orderSource?.marketplace_token) {
              headers['Authorization'] = `ffn ${orderSource.marketplace_token}`
              headers['x-application-id'] = 'JPCB0XLOGYOU'
              headers['x-application-version'] = '0.1'
            }
            if(orderSource?.marketplace_key) headers['x-api-key'] = orderSource.marketplace_key
            if(orderSource?.marketplace_secret) headers['x-api-secret'] = orderSource.marketplace_secret
            if(orderSource?.jtl_merchantID) headers['x-merchant-id'] = orderSource.jtl_merchantID

            // Normalize base URL
            let host = orderSource.marketplace_url.trim()
            if(!/^https?:\/\//i.test(host)) host = `https://${host}`
            host = host.replace(/\/$/, '')

            // Build endpoint URL
            let endpoint = `/api/v1/fulfiller/inbounds/${jtlOrderId}/close`
            if(/\/api\/v1\/fulfiller\/?$/i.test(host)) {
              endpoint = `/inbounds/${jtlOrderId}/close`
            }
            const url = `${host}${endpoint}`

            try {
              const requestLog = { url, method: 'POST', jtl_order_id: jtlOrderId }
              console.log('[JTL Close Inbound] Sending close request to JTL...', requestLog)
              data['jtl_close_inbound_log'] = { ...data['jtl_close_inbound_log'], request: requestLog }

              const jtlResponse = await $fetch(url, { method: 'POST', headers })

              const responseLog = { success: true, response: jtlResponse }
              console.log('[JTL Close Inbound] Successfully closed inbound order:', responseLog)
              data['jtl_close_inbound_log'] = { ...data['jtl_close_inbound_log'], response: responseLog }
            } catch(err: any) {
              const errorLog = {
                error: err?.data ?? err,
                message: err?.message || 'Failed to close JTL inbound order',
                jtl_order_id: jtlOrderId
              }
              console.error('[JTL Close Inbound] Error closing inbound order:', errorLog)
              data['jtl_close_inbound_log'] = { ...data['jtl_close_inbound_log'], error: errorLog }
              // Don't fail the whole document action if JTL close fails
            }
          }
        }
      } catch(err: any) {
        console.error('[JTL Close Inbound] Error in close inbound flow:', err)
        // Don't fail the whole document action if JTL integration fails
      }
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})
